<?xml version="1.0" encoding="UTF-8"?>
<pattern xmlns="http://purl.oclc.org/dsdl/schematron" abstract="true" id="COCT_MT090300" see="http://wiki.hl7.org/index.php?title=Implementatiehandleiding_HL7v3_basiscomponenten_v2.2_Part3#CMET_R_AssignedPersonUniversal">
    <title>R_AssignedDevice universal</title>
    <rule context="$element">
        <assert role="error" test="not(@classCode) or @classCode='ASSIGNED'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/RoleClass.htm#ASSIGNED"
            >COCT_MT090300: @classCode moet indien aanwezig 'ASSIGNED' zijn</assert>
        <assert role="error" test="hl7:id[@root='2.16.840.1.113883.2.4.6.6']"
            >COCT_MT090300: Er moet tenminste een applicatie-id zijn ter identificatie</assert>
    </rule>
    <rule context="$element/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    <rule context="$element/hl7:certificateText">
        <extends rule="ED"/>
    </rule>
    
    <title>assignedDevice</title>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice">
        <assert role="error" test="not(@classCode) or @classCode='DEV'"
            >COCT_MT090300: @classCode moet indien aanwezig 'DEV' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'"
            >COCT_MT090300: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:manufacturerModelName">
        <extends rule="SC"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:softwareName">
        <extends rule="SC"/>
    </rule>
    
    <title>license</title>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:license">
        <assert role="error" test="not(@classCode) or @classCode='LIC'"
            >COCT_MT090300: @classCode moet indien aanwezig 'LIC' zijn</assert>
        <report role="warning" test="."
            >COCT_MT090300: scoping relatie license niet gebruiken</report>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:license/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:license/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:license/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <title>memberOf</title>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf">
        <assert role="error" test="not(@classCode) or @classCode='MBR'"
            >COCT_MT090300: @classCode moet indien aanwezig 'MBR' zijn</assert>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:addr">
        <extends rule="AD"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:telecom">
        <extends rule="TEL"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:statusCode">
        <extends rule="CS"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:effectiveTime">
        <extends rule="IVL_TS"/>
    </rule>
    
    <title>memberOf/group</title>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:group">
        <assert role="error" test="not(@classCode) or @classCode='RGRP'"
            >COCT_MT090300: @classCode moet indien aanwezig 'RGRP' zijn</assert>
        <assert role="error" test="not(@determinerCode) or @determinerCode='INSTANCE'"
            >COCT_MT090300: @determinerCode moet indien aanwezig 'INSTANCE' zijn</assert>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:group/hl7:id">
        <extends rule="II"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:group/hl7:code">
        <extends rule="CE"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:group/hl7:name">
        <extends rule="EN"/>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:memberOf/hl7:group/hl7:desc">
        <extends rule="ED"/>
    </rule>
    
    <title>playedRoleOther</title>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:playedRoleOther">
        <assert role="error" test="not(@classCode) or @classCode='ROL'"
            >COCT_MT090300: @classCode moet indien aanwezig 'ROL' zijn</assert>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:playedRoleOther/hl7:id">
        <extends rule="II"/>
    </rule>
    
    <title>languageCommunication</title>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:languageCommunication">
        <assert role="error" test="not(@classCode) or @classCode='ROL'"
            >COCT_MT090300: @classCode moet indien aanwezig 'ROL' zijn</assert>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:languageCommunication/hl7:languageCode">
        <extends rule="CE"/>
        <assert role="error" test="@codeSystem='2.16.840.1.113883.6.121'"
            >COCT_MT090300: Taalcode moet komen uit codesysteem '2.16.840.1.113883.6.121'</assert>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:languageCommunication/hl7:modeCode">
        <extends rule="CE"/>
        <assert role="error" test="@codeSystem='2.16.840.1.113883.5.60'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/LanguageAbilityMode.htm"
            >COCT_MT090300: Taalexpressiewijzecode moet komen uit codesysteem '2.16.840.1.113883.5.60'</assert>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:languageCommunication/hl7:proficiencyLevelCode">
        <extends rule="CE"/>
        <assert role="error" test="@codeSystem='2.16.840.1.113883.5.61'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/LanguageAbilityProficiency.htm"
            >COCT_MT090300: Taalbeheersingscode moet komen uit codesysteem '2.16.840.1.113883.5.61'</assert>
    </rule>
    <rule context="$element/hl7:assignedPrincipalChoiceList/hl7:assignedDevice/hl7:languageCommunication/hl7:preferenceInd">
        <extends rule="BL"/>
    </rule>
</pattern>